//*************************************************************************************************************************************
//
//  Sample Program for File ( DAT TYPE )
//
//  Target Machine : CPT-711
//
//  Function:
//  int close(int fd)                                    : Close a DAT file.
//  int open(char *filename)                             : Open a DAT file and get the file handle of the file for further processing.
//  int access(char *filename)                           : Check for file existence.
//  long lseek(int fd, long offset, int origin)          : Move file pointer of a DAT file to a new position.
//  int appendln(int fd, char *buffer)                   : Write a null terminated character string to the bottom of a DAT file.
//  long filelength(int fd)                              : Get file length information of a DAT file.
//  int eof(int fd)                                      : Check if file pointer of a DAT file reaches end of file.
//  int readln(int fd, char *buffer, unsigned max_count) : Read a line terminated by a null character from a DAT file.
//  int writeln(int fd, char *buffer)                    : Write a line terminated by a null character(\0) to a DAT file.
//  int remove(char *filename)                           : Delete file.
//
//  SYNTECH INFORMATION CO., LTD.
//
//*************************************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int   i,fd1;
    char  sdat[15], srd[15];
    long  lfsize;

    clr_scr ();
    gotoxy (2, 0);
    puts ("FILE (DAT) TEST");

    for (i=1; i<=32; i++)
        close (i);

    gotoxy (3, 2);
    fd1 = open ("DAT1");
    if (fd1 > 0)
        {
        puts ("DAT1 OPEN OK");
        strcpy (sdat, "APPEND DATA");
        sdat[11] = 0;
        lseek (fd1, 0L, 1);
        appendln (fd1, sdat);
        }
    else
        puts ("DAT1 OPEN NG");

    lseek (fd1, 0L, 1);
    while (!eof(fd1))
        {
        readln (fd1, srd, (unsigned)lfsize);
        gotoxy (3, 3);
        printf ("1.[%s]", srd);
        }

    lfsize = filelength (fd1);
    gotoxy (3, 4);
    printf ("LENGHT:[%ld]", lfsize);

    strcpy (sdat, "WRITE  DATA");
    sdat[11] = 0;
    lseek (fd1, 0L, 1);
    writeln (fd1, sdat);

    lseek (fd1, 0L, 1);
    while (!eof(fd1))
        {
        readln (fd1, srd, (unsigned)lfsize);
        gotoxy (3, 5);
        printf ("2.[%s]", srd);
        }

    close (fd1);

    gotoxy (3, 6);
    if (remove ("DAT1"))
        puts ("DAT1 DEL OK");
    else
        puts ("DAT1 DEL NG");

    while (getchar() != KEY_ESC);
    }
//-------------------------------------------------------------------------//

